<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
$colName = ''; //strtolower($page_header);
$invtTableArry = array('stock', 'stock_sum', 'product_catalog');
$arryStoreUnique = $DB_Config->getSqliteTableNames($_SESSION, $invtTableArry);
//print_r($arryStoreUnique);
//die;
?>
<div class="inventory_list_data" style="display: none;">
    <div class="form-group">
        <label for="filter_inventory" style="padding-top: 5px">Search:</label>
        <input id="filter_inventory" type="text" class="form-control rounded input-sm w-md mb-10 inline-block"/>
    </div>
    <table id="searchTextResults_inventory" data-filter="#filter_inventory" data-page-size="100" class="footable table table-custom">
        <thead>
            <tr>
                <th>#</th>
                <th>Store Unique Key</th>
                <th>Product Name</th>
                <th>Barcode</th>
                <th>MRP Details</th>
                <th>Quantity</th>
                <th>Batch No #</th>
                <th>Price(Batch)</th>
                <th>Quantity Left</th>
                <!--<th>Last Modified</th>-->
            </tr>
        </thead>
        <tbody>
            <?php
            $pagination = true;
            $i = 1;
            $userRecords = $DB_Config->getUserDetailsRecord();

            $request = array(
                "table" => "product_catalog",
                "column" => " `_id`,`name`,`barcode`,`unit_price`,`item_code`,`rateA`,`rateB` ",
                "where" => false,
                "group_by" => " `item_code` ",
                "full_data" => true,
                "is_count" => false,
                "is_sum" => false,
                "arrayIndex" => array('inventory','_id'),
            );
            $prodDetails = $DB_Config->countSqliteTableData($request);

            $request = array(
                "table" => "stock",
                "column" => " `_id`,`product_id`,sum(`quantity`) as `quantity`,`expiry_date`,`batch`,`cost` ",
                "where" => false,
                "group_by" => ' `product_id` ',
                "full_data" => true,
                "is_count" => false,
                "is_sum" => false,
                "arrayIndex" => array('inventory','product_id'),
            );
            $stockDetails = $DB_Config->countSqliteTableData($request);

            $request = array(
                "table" => "stock_sum",
                "column" => " * ",
                "where" => " quantity > 0",
                "group_by" => false,
                "order_by" => ' quantity desc',
                "full_data" => true,
                "is_count" => false,
                "is_sum" => false,
            );

            $saleDetails = $DB_Config->countSqliteTableData($request);
            if (count($saleDetails) > 0) {
                foreach ($saleDetails as $key => $value) {
                    $productTable = "sqlite_" . strtolower($value['store_unique_key']) . "_" . $value['user_id_web'] . "_product_catalog";
                    $stockTable = "sqlite_" . strtolower($value['store_unique_key']) . "_" . $value['user_id_web'] . "_stock";
                    ?>
                    <tr>
                        <td><?php echo $i++; ?></td>
                        <td><?php echo strtoupper($value['store_unique_key']); ?></td>
                        <td><?php echo ucfirst($prodDetails[$productTable][$value['_id']]['name']); ?></td>
                        <td><?php echo $prodDetails[$productTable][$value['_id']]['barcode']; ?></td>
                        <td>
                            <table>
                                <tr>
                                    <td style="width: 40px;">
                                        Cost 
                                    </td>
                                    <td style="width: 60px;"> 
                                        : <?php echo $prodDetails[$productTable][$value['_id']]['unit_price']; ?>
                                    </td>
                                    <td style="width: 60px;border-left: 1px solid lightgray">
                                        Rate A 
                                    </td>
                                    <td style="width: 60px;"> 
                                        : <?php echo $prodDetails[$productTable][$value['_id']]['rateA']; ?>
                                    </td>
                                    <td style="width: 60px;border-left: 1px solid lightgray">
                                        Rate B 
                                    </td>
                                    <td style="width: 60px;"> 
                                        : <?php echo $prodDetails[$productTable][$value['_id']]['rateB']; ?>
                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td><?php echo $stockDetails[$stockTable][$value['_id']]['quantity']; ?></td>
                        <td><?php echo $stockDetails[$stockTable][$value['_id']]['batch']; ?></td>
                        <td><?php echo $stockDetails[$stockTable][$value['_id']]['cost']; ?></td>
                        <td><?php echo $value['quantity']; ?></td>
                    </tr>
                    <?php
                }
            } else {
                echo ""
                . "<tr>"
                . "   <td colspan='9' style='text-align:center;'>No Data available</td>"
                . "</tr>";
                $pagination = false;
            }
            ?>
        </tbody>
        <?php if ($pagination) { ?>
            <tfoot class="hide-if-no-paging ">
                <tr>
                    <td colspan="9" class="text-center">
                        <ul class="pagination"></ul>
                    </td>
                </tr>
            </tfoot>
        <?php } ?>
    </table>
    
    <?php $textType = 'hidden'; ?>
    <form name="exportExcel" action="inventory_list_export.php" method="POST" target="_blank">
        <input type="<?php echo $textType; ?>" name="mode" value="excel" />
    </form>
</div>